/********************************
 *         Party Lane           *
 ********************************
 *  Created by David S Darrell  *
 *       on April 14, 2000      *
 *  Finished on April 16, 2000  *
 * Tools Used: Pov-Ray Win 3.1g *
 * QBASIC (for quick mothod to  *
 * create pre-defined buildings *
 * with Windows                 * 
 ********************************
 *Description: A "First Person" *
 *View from a glider at "People"*
 *gathered in a street with     *
 *balloons flying above         *
 ********************************
 *Files to include:             *
 *Color.inc (with Clear modified*
 *to rgbft 1)                   *
 *metals.inc                    *
 *skies.inc                     *
 *buildings.inc, building1.inc  *
 *balloons.inc                  *
 *people.inc                    *
 ********************************/

//include Standard Files
#include "colors.inc" //modified: #declare Clear = rgbft 1
#include "metals.inc" //for buildings, and metal rails of the glider
#include "skies.inc"  //Sky

//include 
#include "buildings.inc" // The buildings (4 types)
#include "balloons.inc"  // Balloons (200 balloons)
#include "people.inc"    // People (100 people)

//Blue Background with partly clouded sky
background{
    rgb <0,0.3,0.8>
    }

object {
    sphere {0 90001}
    texture {pigment {P_Cloud1} scale 9001 finish{ambient .72}}
    hollow
}

//Sunlight
light_source {<2000, 90000, -45000> color White}

//Hand glider View (tilted to turn)
camera {    
    //angle 20
    location <0, 0, 0>
    look_at <0, -10, 30>
    rotate <0, 0, 25>
    translate <0, 20, -30>
}

//The Hand Glider
union {
    //Fabric part
    object {
        prism {
            linear_sweep
            linear_spline
            0,
            0.01,
            4,
            <0, 0.1>,
            <-0.3, -0.3>,
            <0.3, -0.3>,
            <0, 0.1>
        }
        //Color Blue in the center tinting to red, rest is yellow
        pigment {
            gradient x
            color_map {
                [0 Yellow filter 0.5]
                [0.4 Yellow filter 0.5]
                [0.4 Red filter 0.5]
                [0.5 Blue filter 0.5]
                [0.6 Red filter 0.5]
                [0.6 Yellow filter 0.5]
                [1 Yellow filter 0.5]
            }
            //Center to the frame and scale correctly
            translate <0.5,0,0>
            scale <0.3, 1, 1>
        }
    }
    
    //The frame of the glider (bright aluminum bar frame with center support :)
    object {
        sphere {<0, 0, 0.1> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        sphere {<-0.3, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        sphere {<0.3, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        cylinder {<0, 0, 0.1>, <-0.3, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        cylinder {<0, 0, 0.1>, <0.3, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        cylinder {<-0.3, 0, -0.3>, <0.3, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }
    object {
        cylinder {<0, 0, 0.1>, <0, 0, -0.3> 0.01}
        texture {T_Chrome_3D}
    }

    // Angle to reflect the view,
    rotate <19.4712206344906913692459993399624, 0, 0>
    //offset to view correctly (if was at origin),
    translate <0, 0.02, 0>
    //angle again to match the tilt,
    rotate <0, 0, 25>
    //and offset to the correct position
    translate <0, 20, -29>
}

//Set the city by the ocean
object {
    plane {<0,1,0>, -0.1}
    texture {
        normal {waves}
        pigment{rgb <0,0,.65>}
    scale 1
    //translate wave origination far from the scene
    translate <-5987, 0, 46781>
    }
}    

//Pavement
object {
    box {<-35.5, -.1, -40.5> <35.5, 0, 40.5>}
    texture {pigment {rgb <.2,.2,.2>}}
}

//Rough Sandy beach, side 1 (like Deleware)
object {
    box {<-35.5, -.1, -40.5>, <35.5, 0, -60.5>}
    texture {
        pigment {rgb <1, 0.75, 0.5>}
        finish {crand 0.5 ambient 0.3 phong 0}
    }
}

//Rough Sandy Beach, side 2
object {
    box {<35.5, -0.1, -60.5>, <55.5, 0, 40.5>}
    texture {
        pigment {rgb <1, 0.75, 0.5>}
        finish {crand 0.5 ambient 0.3 phong 0}
    }
}

//The 6  12 story buildings  
object {Building9259 translate <9,0,9>}
object {Building9259 translate <-9,0,9>}
object {Building9259 translate <9,0,-9>}
object {Building9259 translate <27,0,-9>}
object {Building9259 translate <27,0,9>}
object {Building9259 translate <-9,0,-9>}

//3 7 story Brick Buildings (Used another box on each to prevent brick roofs)
difference {
    object {Building9159B}
    object {
        box {<-4.5,14.99,-4.5>, <4.5,15.01,4.5>}
        pigment {rgb <.8,.8,.8>}
    }
    translate <-9,0,-27>
}
difference {
    object {Building9159B}
    object {
        box {<-4.5,14.99,-4.5>, <4.5,15.01,4.5>}
        pigment {rgb <.8,.8,.8>}
    }
    translate <9,0,-27>
}
difference {
    object {Building9159B}
    object {
        box {<-4.5,14.99,-4.5>, <4.5,15.01,4.5>}
        pigment {rgb <.8,.8,.8>}
    }
    translate <27,0,-27>
}

//Combine 1 7 story, 1 12 story, and a 27 story building together to make an impressive "Stacked skyscraper")
union {
    object {Building131513}
    object {Building9259}
    object {Building5555}
    translate <0,0,30>
}

//Unite 2 building with a glass overpass
union {
    object {
        box {<-7, 12, 6.5> <7, 12.1, 7.5>}
        texture {T_Chrome_2C}
    }
    object {
        box {<-7, 14, 6.5> <7, 13.9, 7.5>}
        texture {T_Chrome_2C}
    }
    object {
        box {<-7, 12.1, 6.5> <7, 13.9, 7.5>}
        pigment {rgbft <.5,.9,.9,.9,.7>}
    }
}
        
//Sidewalks that are seen in the image
object {
    superellipsoid {<.1, .1>}
    pigment {rgb <.9,.9,.9>}
    scale <5.5, .1, 5.5>
    translate <9,0,9>
}

object {
    superellipsoid {<.1, .1>}
    pigment {rgb <.9,.9,.9>}
    scale <5.5,.1,5.5>
    translate <-9,0,9>
}

object {
    superellipsoid {<.1, .1>}
    pigment {rgb <.9,.9,.9>}
    scale <5.5,.1,5.5>
    translate <9,0,-9>
}

object {
    superellipsoid {<.1, .1>}
    pigment {rgb <.9,.9,.9>}
    scale <5.5,.1,5.5>
    translate <-9,0,-9>
}

//Crosswalks
difference {
    box {<-6.25, 0, -6.25>, <6.25, 0.01, 6.25>}
    box {<-6, -0.1, -6>, <6, 0.1, 6>}
    pigment {White}
}

difference {
    box {<-4.75, 0, -4.75>, <4.75, 0.01, 4.75>}
    box {<-4.5, -0.1, -4.5>, <4.5, 0.1, 4.5>}
    pigment {White}
}

difference {
    box {<-6.25, 0, -6.25>, <6.25, 0.01, 6.25>}
    box {<-6, -0.1, -6>, <6, 0.1, 6>}
    pigment {White}
    translate <0, 0, -18>
}

difference {
    box {<-4.75, 0, -4.75>, <4.75, 0.01, 4.75>}
    box {<-4.5, -0.1, -4.5>, <4.5, 0.1, 4.5>}
    pigment {White}
    translate <0, 0, -18>
}

difference {
    box {<-6.25, 0, -6.25>, <6.25, 0.01, 6.25>}
    box {<-6, -0.1, -6>, <6, 0.1, 6>}
    pigment {White}
    translate <0, 0, 18>
}

difference {
    box {<-4.75, 0, -4.75>, <4.75, 0.01, 4.75>}
    box {<-4.5, -0.1, -4.5>, <4.5, 0.1, 4.5>}
    pigment {White}
    translate <0, 0, 18>
}


object {
    superellipsoid {<.1, .1>}
    pigment {rgb <.9,.9,.9>}
    scale <7, .1, 7>
    translate <0,0,30>
}

